function [ncDNA messageLen]= BioCode_ncDNA(m)
%BioCode_ncDNA encodes a binary message in ncDNA preventing the creation of
%start codons
% Input arguments:
% m --- the binary message
% Outputs:
% ncDNA --- the encoded DNA
% messageLen --- the number of bits embedded

% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
  
startDinucleotides = ['AT';...
               'CT';...
               'TT';...
               'CA'];

multiplicities = [3 3 3 1];
usableBases = ['ACT';...
               'ACT';...
               'ACT';...
               'C  '];


ncDNA = 'xx';
dnaPOS = 3;

% To prevent out of bounds
m=[m '0'];

i=1;
lenM = length(m);
while i<=lenM-1
    [base increment] = chooseBase(ncDNA(dnaPOS-2),ncDNA(dnaPOS-1),m(i:i+1), startDinucleotides,...
        multiplicities,usableBases);
    ncDNA = [ncDNA base];
    dnaPOS = dnaPOS+1;
    i=i+increment;
end

ncDNA = ncDNA(3:end);
messageLen=i-1;
end

function [base increment] = chooseBase(a,b,m,startDinucleotides,multiplicities,usableBases)

sizes = size(startDinucleotides);

bool = false;

for i =1:sizes(1)
        if strcmp((a),startDinucleotides(i,1))==1 &&...
                strcmp((b),startDinucleotides(i,2))==1 
%             CHange usabel basse
                [base increment] = getBase(multiplicities(i),usableBases(i,:),m);
                bool = true;
        end
end

if bool==false
    [base increment] = getBase(4,'ACTG',m);
end

end

function [base increment] = getBase(multiplicity, usableBases,m)
switch multiplicity
    case 1
        base = usableBases(1);
        increment = 0;
    case 2
        base = usableBases(bin2dec(m(1))+1);
        increment = 1;
    case 3
        if strcmp(m(1:2),'11')==1
            base = usableBases(3);
            increment = 2;
        elseif strcmp(m(1:2),'10')==1
            base = usableBases(2);
            increment = 2;
        else
            base = usableBases(1);
            increment = 1;
        end
    case 4
        base = usableBases(bin2dec(m(1:2))+1);
        increment = 2;
end

if strcmp(base,' ')==1
   disp('asdf') ;
end

end