function [encodedDNA messageLen] = BioCode_pcDNA(dna,m)
%BioCode encodes a message into DNA, preserving the codon count and amino
%acid translation
% Input arguments:
% dna --- host DNA sequence
% m --- binary messate to be embedded
% Outputs:
% encodedDNA --- the encoded DNA sequence
% messageLen --- the number of bits of the binary message embedded

% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  

clear bias;
clear c;
clear y;
clear a;

global bias;
global c;
global y;
global a;

y='';
c='';
a='';
bias='';

dna = upper(dna);
bias = codonbias(dna);
c = codoncount(dna);

% x is a 2d array, each row represents a codon
for i=1:floor(length(dna)/3)
    x(i,:) = dna((i*3)-2:i*3);
end

a = nt2aa(dna,'GENETICCODE',1,'AlternativeStartCodons', false);
j=1;
i=1;
mLength =length(m);
m = [m '000'];

y=x;

while i <= length(a) && j<=mLength
    
    multiplicity = sum(bias.(aminolookup(a(i))).Freq~=0);
    
    switch multiplicity
        case 6
            if strcmp(m(j:j+2),'111')==1
                Decimal = 6;
                Bin=3;
            elseif strcmp(m(j:j+2),'110')==1
                Decimal = 5;
                Bin=3;
            elseif strcmp(m(j:j+2),'101')==1
                Decimal = 4;
                Bin=3;
            elseif strcmp(m(j:j+2),'100')==1
                Decimal = 3;
                Bin=3;
            else
                Decimal = bin2dec(m(j:j+1))+1;
                Bin=2;
            end
        case 5
            if strcmp(m(j:j+2),'111')==1
                Decimal = 5;
                Bin=3;
            elseif strcmp(m(j:j+2),'110')==1
                Decimal = 4;
                Bin=3;
            else
                Decimal = bin2dec(m(j:j+1))+1;
                Bin=2;
            end
        case 4
                Decimal = bin2dec(m(j:j+1))+1;
                Bin=2;
        case 3
            if strcmp(m(j:j+1),'11')==1
                Decimal = 3;
                Bin=2;
            elseif strcmp(m(j:j+1),'10')==1
                Decimal = 2;
                Bin=2;
            elseif strcmp(m(j),'0')==1
                Decimal = 1;
                Bin=1;
            end
        case 2
                Decimal = bin2dec(m(j))+1;
                Bin=1;
    end
    
    if multiplicity>1
       
       setCodon(Decimal,i);
       
       j=j+Bin;
    else
       setCodon(1,i);
    end
    i=i+1;
    
end

while i <= length(a)
    
    multiplicity = sum(bias.(aminolookup(a(i))).Freq>-inf);
    if multiplicity>1
        setCodon(1,i);
    else
        y(i,:) = bias.(aminolookup(a(i))).Codon{1};
    end
    i=i+1;
end

encodedDNA='';

for i=1:length(y)
        encodedDNA = [encodedDNA y(i,:)];
end

messageLen = j-1;

end

% Assigns a codon from amino acid a(i) to y(i,:).
% The codon being assigned based on Decimal.
function  setCodon(Decimal,i)

global bias;
global c;
global y;
global a;

        k = 0;
        position = 0;
        while k<Decimal
            position = position+1;
            if bias.(aminolookup(a(i))).Freq(position)~=0
                k=k+1;
            end
        end
       y(i,:) = bias.(aminolookup(a(i))).Codon{position};
       
%        Reduce Codon count
       c.(y(i,:)) = c.(y(i,:))-1;
       
%        Reduce Multiplicity
       if c.(y(i,:)) == 0
           bias.(aminolookup(a(i))).Freq(position) = 0;
       end

        

end