function binary = BioDecode_pcDNA(encoded, len)
%BioDecode_pcDNA decodes the encoded sequence sequence produced by
%BioCode_pcDNA
% Input arguments:
% encoded --- the encoded DNA sequence
% len --- length of the binary message to be decoded (not really nessecary)
% Outputs:
% binary --- the decoded binary message

% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
clear bias;
clear c;
clear z;
clear a;

global bias;
global c;
global z;
global a;

z='';
c='';
a='';
bias='';

bias = codonbias(encoded);
c = codoncount(encoded);

for i=1:floor(length(encoded)/3)
    z(i,:) = encoded((i*3)-2:i*3);    
end


a = nt2aa(encoded,'GENETICCODE',1,'AlternativeStartCodons', false);
mHat = '';

for i=1:length(z)
          mHat = [mHat getBin(i)];
          if length(mHat)>= len
             break; 
          end
end

binary = mHat(1:min(length(mHat),len));
    
end

function  bin = getBin(i)

global bias;
global c;
global z;
global a;

bin='';

        multiplicity = sum(bias.(aminolookup(a(i))).Freq~=0);
        if multiplicity>1
            k = 0;
            position = 0;
            codonPosition = -1;
            Decimal = -1;
%             Find position that codon is relative to multiplicity
            while k<multiplicity
                position = position+1;
                if bias.(aminolookup(a(i))).Freq(position)~=0
                    k=k+1;
                end 
                if strcmp(bias.(aminolookup(a(i))).Codon{position}, z(i,:)) ==1
                    Decimal = k;
                    codonPosition = position;
                end
            end

            bin = decimal2bin(Decimal , multiplicity);

    %        Reduce Codon count
           c.(z(i,:)) = c.(z(i,:))-1;

    %        Reduce Multiplicity
           if c.(z(i,:)) == 0
               bias.(aminolookup(a(i))).Freq(codonPosition) = 0;
           end
        end

        

end

function dec = decimal2bin(decimal , multiplicity)

dec ='';
    switch multiplicity
          case 6 
                  if decimal == 6
                      dec = '111';
                  elseif decimal == 5
                      dec = '110';
                  elseif decimal == 4
                      dec = '101';
                  elseif decimal == 3
                      dec = '100';
                  elseif decimal == 2
                      dec = '01';
                  elseif decimal == 1
                      dec = '00';
                  end
          case 5
              
                  if decimal ==5
                      dec = '111';
                  elseif decimal ==4
                      dec = '110';
                  elseif decimal ==3
                      dec = '10';
                  elseif decimal == 2
                      dec = '01';
                  elseif decimal == 1
                      dec = '00';
                  end
          case 4
                  if decimal ==4
                      dec = '11';
                  elseif decimal ==3
                      dec = '10';
                  elseif decimal == 2
                      dec = '01';
                  elseif decimal == 1
                      dec = '00';
                  end
          case 3
                  if decimal ==3
                      dec = '11';
                  elseif decimal == 2
                      dec = '10';
                  elseif decimal == 1
                      dec = '0';
                  end
          case 2
                  if decimal ==2
                      dec = '1';
                  elseif decimal == 1
                      dec = '0';
                  end
     end

end