function m = deMarker(z, step)

% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  

step=step+3;

for i=1:step:length(z)-(step-1)
    markhat = z(i+(step-3):i+(step-1));
    
    if strcmp('001',markhat)~=1
         z = action(markhat,z,i,step);
    end
    if i+step+step>length(z)
        break;
    end
end

len = step-4;
current=1;

for i=1:step:length(z)-(step-1)
    m(current:current+len)= z(i:i+len);
   current=current+len+1;
end

if i+step-1<length(z)
   m=[m z(i+step:end)]; 
end

end

function z = action(markhat,z,i,step)

    a = '0';
    if randn>0
        a='1';
    end

    half1 = floor((step-1)/2);
    
if strcmp(markhat,'000')==1
%     insertion
        z=[z(1:i+half1) z(i+half1+2:end)];
elseif strcmp(markhat,'001')==1
%     correct
    z=z;
elseif strcmp(markhat,'010')==1
%     deletion
        z=[z(1:i+half1) a z(i+half1+1:end)];
elseif strcmp(markhat,'011')==1
%     deletion
% z=z;
        z=[z(1:i+half1) a z(i+half1+1:end)];
elseif strcmp(markhat,'100')==1
        z=[z(1:i+half1) z(i+half1+2:end)];
elseif strcmp(markhat,'101')==1
    z=z;
elseif strcmp(markhat,'110')==1
        %     insertion
        z=[z(1:i+half1) z(i+half1+2:end)];
elseif strcmp(markhat,'111')==1
%     2 flips
z=z;
end

end