function [mHat newLen realigned] = deWatermark(z,watermarker,positions,subcost,indelcost)
% deWatermark extracts the message from a watermark + message vector.
% Input arguments:
% z --- the watermark + message + mutations
% watermarker --- the original watermark vector
% positions --- the positions in watermarker that contain message bits
% subcost --- the cost of a substitution mutation
% indelcost --- the cost of a deletion
% Output arguments:
% mHat --- the retrieved message
% newLen --- the length of the retrieved message
% realigned --- the realigned watermark + message vector.


% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  

       [x realigned] = editResolve(watermarker,z,indelcost,indelcost,subcost);
        
        mHat = realigned(positions(positions<=length(realigned)));
        
        newLen=length(mHat);
        mHat = strtrim(mHat);
end

function [d alignment] = editResolve(s1,s2,varargin)
%EDITDIST Finds the Edit Distance between strings s1 and s2. The Edit Distance
%         is defined as the minimum number of single-character edit operations 
%         (deletions, insertions, and/or replacements) that would convert 
%         s1 into s2 or vice-versa. Uses an efficient dynamic programming
%         algorithm. Useful for gene sequence matching, among other applications.
%
%         Example: d = EditDist('cow','house') returns a value of 4.
%         Example: s1 = 'now'; s2 = 'cow'; EditDist(s1,s2) returns a value of 1.
%         Example from gene sequence matching:
%         EditDist('ATTTGCATTA','ATTGCTT') returns a value of 3.
%         
%         If there are more than two inputs, the 3d, 4th, and 5th inputs will be
%         interpreted as the costs of the three edit operations: DELETION,
%         INSERTION, and REPLACEMENT respectively. The default is 1 for all
%         three operations. Note that if the cost of replacement is at least twice
%         the respective costs of deletion and insertion, replacements will never be 
%         performed.
%
%         Example: EditDist('cow','house',1,1,1) returns a value of 4.
%         Example: EditDist('cow','house',1,2,1.5) returns a value of 5.
%         Example: EditDist('cow','house',1,1,2) returns a value of 6.
%
%
%USAGE:   d = EditDist('string1','string2');
%
%         d = EditDist('string1,'string2',1.5,1,2);
%
%

%Written and tested in Matlab 5.3, Release 11.1 (should work with earlier versions).
%Copyright 2000, Miguel A. Castro 6/4/2000
%talk2miguel@yahoo.com
%------------------------------------------------------------------------------------------

%Determine the number of inputs. If 2 inputs, set default edit costs to 1.
%Otherwise, make sure there are exactly 5 inputs, and set edit costs accordingly.
if ~isempty(varargin)
   if length(varargin) ~= 3
      error('Usage is: EditDist(''string1'',''string2'',DeleteCost,InsertCost,ReplaceCost)');
   end;
   DelCost = varargin{1};
   InsCost = varargin{2};
   ReplCost = varargin{3};
else
   DelCost = 2;
   InsCost = 2;
   ReplCost = 1;
end;

[m1,n1] = size(s1);
[m2,n2] = size(s2);

%Make sure input strings are horizontal.
if ~(ischar(s1) & ischar(s2) & m1 == 1 & m2 == 1)  
   error('s1 and s2 must be horizontal strings.');
end;

%Initialize dynamic matrix D with appropriate size:
D = zeros(n1+1,n2+1);

%This is dynamic programming algorithm:
for i = 1:n1
   D(i+1,1) = D(i,1) + DelCost;
end;

for j = 1:n2
   D(1,j+1) = D(1,j) + InsCost;
end;
b=zeros(1,max(length(s1),length(s2)));
for i = 1:n1
   for j = 1:n2
      if s1(i) == s2(j)
         Repl = 0;
      else
         Repl = ReplCost;
      end;
      [D(i+1,j+1) b(j)] = min([D(i,j)+Repl D(i+1,j)+DelCost D(i,j+1)+InsCost]);
   end;
end;

%b, 1 = match or sub

i=n1+1; % first or row
j=n2+1; % second or column

a = s1;
b = s2;

temp = D(n1+1,n2+1);
alignment='';
% 
% alignment=s1(end);
% if s1(end)~=s2(end)
%     if rand>0.5
%             alignment=s2(end);
%     end
% end

% i-1 goes accross
% j-1 goes up

% disp(D);
AlignA='';
AlignB='';
while i>1&&j>1
score = D(i,j);
scoreDiag = D(i-1,j-1);
scoreUp = D(i-1,j);
scoreLeft = D(i,j-1);

if (score-InsCost==scoreUp)

        AlignA = [a(i-1) AlignA];
        AlignB = ['-' AlignB];
        i=i-1;
        
%         AlignA = ['-' AlignA];
%         AlignB = [b(j-1) AlignB];
%         j=j-1;
    elseif (score-DelCost==scoreLeft)

        AlignA = ['-'  AlignA];
        AlignB = [b(j-1) AlignB];
        j=j-1;
%         AlignA = [a(i-1) AlignA];
%         AlignB = ['-' AlignB];
%         i=i-1;
elseif (score==scoreDiag)

        AlignA = [a(i-1) AlignA];
        AlignB = [b(j-1) AlignB];
        i=i-1;
        j=j-1;
elseif (score==scoreDiag+ReplCost)

        AlignA = [a(i-1) AlignA];
        AlignB = [b(j-1) AlignB];
        i=i-1;
        j=j-1;

end

end

while (i>1)
        AlignA = [a(i-1) AlignA];
        AlignB = ['-' AlignB];
        i=i-1;
end

while (j>1)
        AlignA = ['-' AlignA];
        AlignB = [b(j-1) AlignB];
        j=j-1;
end

% while (i>1)
%         AlignA = [a(i-1) AlignA];
%         AlignB = ['-' AlignB];
%         i=i-1;
% end
% 
% while (j>1)
%         AlignA = ['-' AlignA];
%         AlignB = [b(j-1) AlignB];
%         j=j-1;
% end
% 
% disp(AlignA);
% disp(AlignB);

for i =1:length(AlignB)
    if strcmp(AlignB(i),'-')==1
        AlignB(i)=AlignA(i);
%         AlignB(i)=b(i);
%         disp('sadf');
    end
end

while strcmp(AlignA(end),'-')==1
        AlignB = [AlignB(1:end-1)];
        AlignA = [AlignA(1:end-1)];
end

i=length(AlignA);

while i>0
%     disp(AlignA);
    if  strcmp(AlignA(i),'-')==1
        AlignB = [AlignB(1:i-1) AlignB(i+1:end)];
        AlignA = [AlignA(1:i-1) AlignA(i+1:end)];
    else
        i=i-1;
    end
end

%     elseif strcmp(AlignA(i),'-')==1
%         AlignB = [AlignB(1:i-1) AlignB(i+1:end)];
%     end

% disp(D);

alignment=AlignB;

d = D(n1+1,n2+1);

end