function [dna transitions transversions] = kimuraMutate(dna, q, gamma, m)

% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
  
V = 0.5*[1, 1, -sqrt(2),0;...
        1,-1,0,-sqrt(2);...
        1,-1,0,sqrt(2);...
        1, 1,sqrt(2),0];

lambda = 1-((4*gamma)/3)*q;
mu = 1-2*(1-(gamma/3))*q;
    
D = [1, 0, 0, 0;...
     0, lambda, 0, 0;...
     0, 0, mu, 0;...
     0, 0, 0, mu];

pie = V* (D^m)*transpose(V);

gRate = pie(1,2);
otherQ = pie(1,4);

 randSelection = randperm(length(dna));
 numberOfTransitions = round(length(dna)*otherQ);
 numberOfTranslation = round(length(dna)*gRate*2);
 
 transversions = gRate;
 transitions = otherQ;

 subs = (numberOfTransitions+numberOfTranslation);
 
transitionLocations = randSelection(1:numberOfTransitions);
translationLocation = randSelection(numberOfTransitions+1:subs);


 for i = 1:numberOfTransitions 
     if strcmp(dna(transitionLocations(i)),'A')
         dna(transitionLocations(i)) = 'G';
     elseif strcmp(dna(transitionLocations(i)),'C')
         dna(transitionLocations(i)) = 'T';
     elseif strcmp(dna(transitionLocations(i)),'T')
         dna(transitionLocations(i)) = 'C';
     else
         dna(transitionLocations(i)) = 'A';
     end
 end
 
 for i = 1:numberOfTranslation
     if strcmp(dna(translationLocation(i)),'A')
        if rand>0.5
            dna(translationLocation(i)) = 'C';
        else
            dna(translationLocation(i)) = 'T';
        end
     elseif strcmp(dna(translationLocation(i)),'C')
        if rand>0.5
            dna(translationLocation(i)) = 'A';
        else
            dna(translationLocation(i)) = 'G';
        end
     elseif strcmp(dna(translationLocation(i)),'T')
        if rand>0.5
            dna(translationLocation(i)) = 'A';
        else
            dna(translationLocation(i)) = 'G';
        end
     else
        if rand>0.5
            dna(translationLocation(i)) = 'C';
        else
            dna(translationLocation(i)) = 'T';
        end
     end  
 end
 

end
