function m= BioDecode_ncDNA(z)
%BioCode_ncDNA decodes the DNA sequence produced by BioCode_ncDNA
% Input arguments:
% z --- encoded DNA sequence
% Outputs:
% m --- the binary message


% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
startDinucleotides = ['AT';...
               'CT';...
               'TT';...
               'CA'];

multiplicities = [3 3 3 1];
usableBases = ['ACT';...
               'ACT';...
               'ACT';...
               'C  '];

startCodons = ['ATG';...
               'CTG';...
               'TTG';...
               'CAG';...
               'CAA';...
               'CAT'];

z = ['xx' z];
m='';

i=3;

temp = size(startCodons);
stCo = temp(1);
while i<=length(z)
    
   for j=1:stCo
      if i<=length(z)-2 &&...
              strcmp(z(i:i+2),startCodons(j,:))==1
          if strcmp(z(i:i+1),'CA')
             z(i+2) ='C';
          else
             z(i) = 'G';
          end
      end
   end
    
    bits  = chooseBits(z(i-2),z(i-1),z(i),...
        startDinucleotides,multiplicities,usableBases);
    m=[m bits];
    i=i+1;
end

 end

function bits = chooseBits(a,b,z,startDinucleotides,multiplicities,usableBases)

sizes = size(startDinucleotides);

bool = false;

for i =1:sizes(1)
        if strcmp((a),startDinucleotides(i,1))==1 &&...
                strcmp((b),startDinucleotides(i,2))==1 
%             CHange usabel basse
                bits  = getBits(multiplicities(i),usableBases(i,:),z);
                bool = true;
        end
end

if bool ==false
    bits = getBits(4,'ACTG',z);
end

end

function bits = getBits(multiplicity, usableBases,z)
position = findstr(z,usableBases);
switch multiplicity
    case 1
        bits = '';
    case 2
        bits = dec2bin(position-1);
    case 3
        if position==3
            bits = '11';
        elseif position==2
%             recursion
            bits = '10';
        else
            bits = '0';
        end
    case 4
        if position==1
            bits ='00';
        elseif position ==2
            bits ='01';
        else
            bits = dec2bin(position-1);
        end
end

end