function [H G] = createLDPCMatrices()

% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  

m=20;
p = zeros(m/2);
a=2;

for i =1:(m/2)
     p= getPosition(p, a);
end

H = [p eye(m/2,m/2)];

for i =1:m/2
    for j=1:m/2
        if H(i,j)>0
           H(i,j) =floor(rand*3)+1;
        end
    end
end

H=gf(H,2);

G = gf([eye(m/2,m/2) transpose(H(:,1:m/2))],2);

res= G*H';
res=res.x;
Hp = H.x;
for i=1:m/2
   if sum(Hp(i,:))==1
      error('A row of H only has 1 value');
   end
end

for i=1:m/2
    if sum(Hp(:,i))==1
      error('A column of H only has 1 value');
   end
end

if sum(sum(res))>0
   error('Partity and Generator Matrices are wrong');
end


end


function p= getPosition(p, number)

[s1 s2]=size(p);

sums = sum(p,1);
[val pos] = sort(sums);
pos = find(sums==val(1));
newposes = randperm(length(pos));
actuali = pos(newposes(1));
bool = true;
iteration = 1000;
l=1;
while bool
    otherposes  = randperm(s1);
    otherposes=otherposes(1:number);
    for i =1:s1
        if i~=actuali
            times = 0;
            for j =1:length(otherposes)
                if p(otherposes(j),i)~=0 
                    times=times+1;
                end
            end
            if times>1
               bool= true; 
               break;
            else
               bool =false; 
            end
        end
    end
    if l>=iteration
        number=number-1;
        if number<=0
           error('Matrix not constructed properly') ;
        end
    end
    l=l+1;
end

p(otherposes,actuali)=1;

end

function bool = check(row)
    temp=gf(row,2);
    summation=gf(0,2);
    for i=1:length(temp)
        summation=summation+temp(i);
    end
    s=summation.x;
    
    if s==0
        bool=1;
    else
        bool=0;
    end
end