function decoded = decodeLDPCFourierQuaternary(encoded, H,G, generations,q,gamma,iterations)
% probabilityMatrix is a transition matrix in the form A,C,T,G accross and
% down. {A, C, T, G} \mapsto {0, 1, 2, 3}


% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  

  
[s1 s2]=size(H);
% calulateSumPart(H,G);
% calulateSumPart2(H,G);
decoded='';
errorFound=0;
for i=1:s2:length(encoded)-s2+1
    temp = zeros(1,s2); 
    for j =0:s2-1
       temp(j+1)=str2num(encoded(i+j));
%        newReal(j+1)=str2num(real(i+j));
    end
    
    coded = H*gf(temp',2);
    coded=coded.x;
    
    if sum(coded)~=0
        errorFound = errorFound+1;
    end
    
end

getTransprob(q, gamma, generations,s2,length(encoded),errorFound);

[g1 g2]=size(G);
newReal=encoded;
for i=1:s2:length(encoded)-s2+1
    temp = zeros(1,s2); 
    for j =0:s2-1
       temp(j+1)=str2num(encoded(i+j));
%        newReal(j+1)=str2num(real(i+j));
    end
    
    coded = H*gf(temp',2);
    coded=coded.x;
    
    if sum(coded)~=0
        disp(['Solving ' num2str(i) ' of ' num2str(length(encoded))]);
        temp = resolveBlock(H,gf(temp,2),newReal,iterations);
    end
    
    for j =1:g1
         decoded=[decoded num2str(temp(j))]; 
    end
    
end

end

function getTransprob(q, gamma, m, blockLen, totalLen, erronousBlocks)
global transitionMat;
% I commented out this this for ML decoding
% relativeq = (totalLen/(blockLen*erronousBlocks)) * (q);
relativeq=q;
a = (1-relativeq);
b = (gamma/3)*relativeq;
c = (1-((2*gamma)/3))*relativeq;

Pie = [a b b c;...
       b a c b;...
       b c a b;...
       c b b a];

Pie=Pie^m;
transitionMat=Pie;

end

function nHat = resolveBlock(H,x,newReal,iterations)



global transitionMat;
H=H.x;
% load('test.mat');
 [n m]=size(H);
Q = zeros(4,n,m);
R = zeros(4,n,m);
f=zeros(4,length(x));
chat = 0;
nHat='';

for i=1:length(x)
    temp = x(i);
    f(:,i) =transitionMat(temp.x+1,:);
end


 
 % Calualte the original Q matrix
 for i =1:n  % row
   for j=1:m % col
         if H(i,j)~=0
            Q(:,i,j)  = f(:,j);
         end
   end
 end
 

 for w = 1:iterations

    %  Permute Q
     for i =1:n  % row
       for j=1:m % col
             if H(i,j)>1
                 if H(i,j)==2
                    Q(:,i,j) = Q([1 4 2 3],i,j); 
                 else
                    Q(:,i,j) = Q([1 3 4 2],i,j);                  
                 end
             end
       end
     end


    %  Populate F(Q), i.e. the fourier transform
     FQ = zeros(4,n,m);

     a= [1 1 1 1;...
     1 -1 1 -1;...
     1 1 -1 -1;...
     1 -1 -1 1];

     for i =1:n  % row
       for j=1:m % col
             if H(i,j)>0
                FQ(:,i,j)= a*Q(:,i,j);
             end
       end
     end

    % Populate R
      for i =1:n  % row
       for j=1:m % col
                if H(i,j)>0
                    pos = [1:m];
                    pos(pos==j)=[];
                     temp =FQ(:,i,pos);
                     vec = reshape(temp,[4 length(pos)]);
                     l=1;
                     [s1 s2]=size(vec);
                     while l<=s2
                        if sum(vec(:,l))==0
                           vec(:,l)=[];
                           [s1 s2]=size(vec);
                        else
                           l=l+1; 
                        end
                     end
                     b=prod(vec,2);
                     c=0.25*(a*b);
                     R(:,i,j)=c;
                end
       end
      end

    %  Depermute R
     for i =1:n  % row
       for j=1:m % col
             if H(i,j)>1
                 if H(i,j)==2
                    R(:,i,j) = R([1 3 4 2],i,j); 
                 else
                    R(:,i,j) = R([1 4 2 3],i,j);                  
                 end
             end
       end
     end

     Qprime = zeros(4,m);
        for j=1:m
            for i=1:n    
               if H(i,j)~=0
                   temp = R(:,:,j);
                   temp(:,i)=[];
                   temp0 = temp(1,:);
                   temp1 = temp(2,:);
                   temp2 = temp(3,:);
                   temp3 = temp(4,:);

                   temp0=temp0(temp0>0);
                   temp1=temp1(temp1>0);
                   temp2=temp2(temp2>0);
                   temp3=temp3(temp3>0);

                    temp0 =  f(1,j)*prod(temp0);
                    temp1 =  f(2,j)*prod(temp1);
                    temp2 =  f(3,j)*prod(temp2);
                    temp3 =  f(4,j)*prod(temp3);


                    Q(1,i,j) = temp0/(temp0+temp1+temp2+temp3);
                    Q(2,i,j) = temp1/(temp0+temp1+temp2+temp3);
                    Q(3,i,j) = temp2/(temp0+temp1+temp2+temp3);
                    Q(4,i,j) = temp3/(temp0+temp1+temp2+temp3);



               end
            end

                            %               Calulate estimate
               temp = R(:,:,j);
               temp0 = temp(1,:);
               temp1 = temp(2,:);
               temp2 = temp(3,:);
               temp3 = temp(4,:);

               temp0=temp0(temp0>0);
               temp1=temp1(temp1>0);
               temp2=temp2(temp2>0);
               temp3=temp3(temp3>0);

                temp0 =  prod(temp0);
                temp1 =  prod(temp1);
                temp2 =  prod(temp2);
                temp3 =  prod(temp3);


                Qprime(1,j)=temp0;
                Qprime(2,j)=temp1;
                Qprime(3,j)=temp2;
                Qprime(4,j)=temp3;

            Qprime(1,j)=Qprime(1,j)*f(1,j);
            Qprime(2,j)=Qprime(2,j)*f(2,j);
            Qprime(3,j)=Qprime(3,j)*f(3,j);
            Qprime(4,j)=Qprime(4,j)*f(4,j);

            overall  =(Qprime(1,j)+Qprime(2,j)+Qprime(3,j)+Qprime(4,j));
            Qprime(1,j)=Qprime(1,j)/overall;
            Qprime(2,j)=Qprime(2,j)/overall;
            Qprime(3,j)=Qprime(3,j)/overall;
            Qprime(4,j)=Qprime(4,j)/overall;
        end

disp(w);


        [a chat]=max(Qprime);
        chat=chat-1;
        chat=gf(chat,2);
        result = H*chat';
        result=result.x;
        overallSum = sum(result);
%          disp(double(chat.x));
%          disp(newReal);

    if sum(sum(isnan(Qprime)))>0
        disp('uho');
    end

%      disp(chat.x);
%         disp(Qprime);
    if overallSum==0
%         disp(Qprime);
%         disp(chat.x);
        nHat=chat.x;
        break;
    end

 end

 nHat=chat.x;
 
%  res = sum(nHat~=newReal);
%  originalres = sum(x.x~=newReal);
%  disp(['difference: ' num2str(res)]);
%  disp(['Original difference: ' num2str(originalres)]);
 
end

         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         