function [dna pie numberOfTransitions numberOfTranslation] = kimuraMutate(dna, q, gamma, m)

% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  

V = 0.5*[1, 1, -sqrt(2),0;...
        1,-1,0,-sqrt(2);...
        1,-1,0,sqrt(2);...
        1, 1,sqrt(2),0];

lambda = 1-((4*gamma)/3)*q;
mu = 1-2*(1-(gamma/3))*q;
    
D = [1, 0, 0, 0;...
     0, lambda, 0, 0;...
     0, 0, mu, 0;...
     0, 0, 0, mu];

pie = V* (D^m)*transpose(V);

gRate = pie(1,2);
otherQ = pie(1,4);

 randSelection = randperm(length(dna));
 numberOfTransitions = round(length(dna)*otherQ);
 numberOfTranslation = round(length(dna)*gRate*2);

 subs = (numberOfTransitions+numberOfTranslation);
 
transitionLocations = randSelection(1:numberOfTransitions);
translationLocation = randSelection(numberOfTransitions+1:subs);


 for i = 1:numberOfTransitions 
     if strcmp(dna(transitionLocations(i)),'0')
         dna(transitionLocations(i)) = '3';
     elseif strcmp(dna(transitionLocations(i)),'1')
         dna(transitionLocations(i)) = '2';
     elseif strcmp(dna(transitionLocations(i)),'2')
         dna(transitionLocations(i)) = '1';
     else
         dna(transitionLocations(i)) = '0';
     end
 end
 
 for i = 1:numberOfTranslation
     if strcmp(dna(translationLocation(i)),'0')
        if rand>0.5
            dna(translationLocation(i)) = '1';
        else
            dna(translationLocation(i)) = '2';
        end
     elseif strcmp(dna(translationLocation(i)),'1')
        if rand>0.5
            dna(translationLocation(i)) = '0';
        else
            dna(translationLocation(i)) = '3';
        end
     elseif strcmp(dna(translationLocation(i)),'2')
        if rand>0.5
            dna(translationLocation(i)) = '0';
        else
            dna(translationLocation(i)) = '3';
        end
     else
        if rand>0.5
            dna(translationLocation(i)) = '1';
        else
            dna(translationLocation(i)) = '2';
        end
     end  
 end
 
 

end
