function test_ncDNA

% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
  
clc;

% Message vector
m = char(double(randn(1,100)>0.5)+48);

% Watermark code
[mprime positions watermarker] = watermark(m,200);

% Marker code
% step = 100;
% mprime = marker(m,step);

% Encode m
y = BioCode_ncDNA(mprime);

% Mutate DNA
q = 10^-8;
gamma = 0.1;
generations = 10^7;
z = kimuraMutate(y, q, gamma, generations);

% Decode 
m_decoded= BioDecode_ncDNA(z);

% Remove marker
% mhat = deMarker(m_decoded, step);

% Remove watermark
mhat = deWatermark(m_decoded,watermarker,positions,1,3);

% Calulate Errors
disp(['Probabilitiy of error: ' ...
    num2str(pdist([double(mhat(1:length(m)));double(m)],'hamming'))]);

% Start codons may appear due to mutations
% checkStartCodon(y);

end

function checkStartCodon(y)
startCodons = ['ATG';...
               'CTG';...
               'TTG';...
               'CAG';...
               'CAA';...
               'CAT'];
bool= 1;
for i =1:length(y)-2
    for j=1:6
       if strcmp(startCodons(j,:),y(i:i+2)) 
           bool=0;
       end
    end
end

if bool == 1
   disp('Start codon not found');
else
   disp('Start codon found'); 
end

end