function test_pcDNA


% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
  
clc;

% Message vector
m = char(double(randn(1,10000)>0.5)+48);

% Host DNA sequence
x = randseq(300);

% Encode m in x
[y len] = BioCode_pcDNA(x,m);

% Decode
mhat = BioDecode_pcDNA(y, len);

% Calulate Errors
disp(['Probabilitiy of error: ' ...
    num2str(pdist([double(mhat);double(m(1:len))],'hamming'))]);

% Print message length and embedding rate
disp([num2str(len) ' bits embedded; ' num2str(3*(len/length(y))) ' bits/codon']);

% Test if codon count is the same
testCodonCount(x,y);

% Test if amino aicd is the same
testAminoAcidTranslation(x,y)

end

function testAminoAcidTranslation(x,y)
ax = nt2aa(x);
ay = nt2aa(y);

if sum(ax~=ay)>0
   disp('Incorrect amino acid translation') ;
else
    disp('Correct amino acid translation') ;
end

end

function testCodonCount(x,y)
xcount = codoncount(x);
ycount = codoncount(y);

names = fieldnames(xcount);
bool = 1;

for i =1:length(names) 
    if xcount.(names{i})~=ycount.(names{i})
       bool=0; 
    end
end

if bool == 1
   disp('Codon count preserved');
else
   disp('Codon count not preserved'); 
end

end