function [y positions watermarker]= watermark(m, waterSize)
% watermark --- adds a message to a watermark
% Input arguments
% m --- the binary message
% waterSize --- the size of the watermark vector
% Output arguments
% y --- the watermark + message
% positions --- the positions in watermarker that contain message bits
% watermarker --- the original watermark vector

% Copyright (C) 2013 David Haughton and Félix Balado
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
        watermarker = char(double(randn(1,floor(waterSize))>0.5)+48);
        
        
%         positions = [1:spacing:floor(waterSize)];
        positions = round(linspace(1,waterSize-4,length(m)));
        positions=unique(positions);
        if length(positions)~=length(m)
           positions = sort(randperm(floor(waterSize)-4)); 
           positions = positions(1:length(m));
        end
        
        y=watermarker;
        y(positions) = m;

end