function [u,uh]=partitioning_lsb(x,decorr)
% PARTITIONING_LSB - obtain support partitioning uh to do
%                    histogram-preserving LSB steganography, 

% Copyright (C) 2014 Félix Balado and David Haughton
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
% $Id: partitioning_lsb.m,v 1.4 2014/10/17 10:47:57 felix Exp $  
  
  [v,i,j]=unique(x);
  if nargin==1         % ... -1 -1 0 0 1 1 2 2 ...
    uh=floor(v/2); 
  else                % ... -1 -1 0 1 1 2 2 ...
    fprintf(1,'skipping zero\n');
    uh=zeros(size(v));
    uh(v>0)=ceil(v(v>0)/2);
    uh(v<0)=floor(v(v<0)/2);
  end

% support-induced partitioning
  u=zeros(size(x));
  u=uh(j); % from unique(x)
    
    