function md=stegano100_lsb_decode(im_file_name,key)
% STEGANO100_LSB_DECODE - 
%
%         im_file_name - grayscale image, with extension
%                  key - symmetric key
  
% Copyright (C) 2014 Félix Balado and David Haughton
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
% $Id: stegano100_lsb_decode.m,v 1.2 2014/10/17 09:39:57 felix Exp $
            
% load image
      fprintf('Loading: %s\n\n',im_file_name);
      im_r=imread(im_file_name);
      yr=double(im_r(:)');
      n=length(yr);
      
% partition and find out theoreticals
      ud=partitioning_lsb(yr);
      [lrd,hwr,hwrm,lb_eff,nu,sx]=theoreticals(yr,ud);
      psnr=hwr-10*log10(norm(yr)^2)+10*log10(n*255^2);
      rho=sum(lrd)/n;
      fprintf('Theoretical measures: \n\n');
      fprintf('Host to average watermark power ratio:\n\tHWR=%.4f dB (PSNR=%.4f dB) [minimum HWR=%.4f dB]\n',hwr,psnr,hwrm);
      fprintf('Average degree of host change:\n\tnu=%1.3f\n',nu);    
      fprintf('Embedding rate:\n\trho=%.4f bits/host sample\n',rho);
      fprintf('Lower bound on average embedding efficiency:\n\tepsilon=%.4f bits/host sample change\n\n',lb_eff);
      
% decode
      fprintf('Decoding...\n');
      md=[];
      uu=unique(ud);
      rand('twister',key); % initialise pseudorandom generator
      for j=1:length(uu)
        fprintf('\rPartition: %i/%i',j,length(uu));
	mjl=floor(lrd(j));
	y_j=yr(ud==uu(j));
	y_j_d=zeros(size(y_j));
        if mjl>0
	  ind_key=randperm(length(y_j));
	  y_j_d(ind_key)=y_j;
%	  md_j=permutation_decoding_m(y_j_d,mjl); % matlab
	  md_j=permutation_decoding(y_j_d,mjl);   % mex
	  md=[md md_j];
        end            
      end   
      fprintf('\n');
    