function test_permutation_coding()
% TEST_PERMUTATION_CODING - test permutation coding

% $Id: test_permutation_coding.m,v 1.1 2014/10/17 02:04:41 felix Exp felix $
  
  
  % some longish arbitrary vector to showcase unranking and ranking permutations
  % from a multiset:
  x=[3 2 1 3 4 2 3 3 2 5 5 2 1 3 4 3 1 1 7 3 9 3 1 8];
  
  % if you use the Mex files provided, long vectors can be easily handled 
  % (for instance: ranking or unranking a vector with 10^6 elements takes just a couple of seconds in an oldish machine)
  
  v=unique(x);
  h=histc(x,v);
  
  %% bits determination
  max_nr_bits=log2_multinomial(h);
  nr_bits=floor(max_nr_bits);
  
  iterations=50000; % try many different rearrangements (permutations) of x
  for w=0:iterations-1
    fprintf('\r%i/%i',w+1,iterations);        
    
    m=(rand(1,nr_bits)>0.5); % random rank (binary string)
    
    % if rank is decimal number 0<=r<2^nr_bits, instead of binary string:
    % r=floor(rand*(2^nr_bits));
    % m=dec2bin(r,nr_bits)-'0'; 
    
    %% unrank m
    %y=permutation_encoding_m(x,m); % matlab
    y=permutation_encoding(x,double(m));    % mex
    
    %% rank permutation y
    %md=permutation_decoding_m(y,nr_bits); % matlab
    md=permutation_decoding(y,nr_bits);    % mex

    % rank md in decimal:
    % rd=sum(md.*2.^(numel(md)-1:-1:0));
    
    %% check if ranked correctly
    if(sum(md~=m)>0) % or rd~=r
      fprintf('warning: error!\n');
    end
    
  end
  fprintf('\n');        
