function test_stegano100()
% TEST_STEGANO100 - Tests histogram-preserving steganography using 
%                   permutation coding
%                   Encoder and decoder agree on minimum PSNR and go with
%                   the resulting theoretical embedding rate

% $Id: test_stegano100.m,v 1.1 2014/10/13 17:45:02 felix Exp felix $  
  
  % host file
  im_file_name='lena512.png';
%  im_file_name='Goldhill.png';
%  im_file_name='boat.png';
  
  % create message 
  n=512^2; % assume 1 bpp, depending on minimum PSNR chosen the embedding rate will be lower or greater
  m=(rand(1,n)>.5);  
  
  % minimum PSNR
  psnr_min=55;

  % choose some key
  key=floor(rand*2^32);
  
  % embed
  [ml,im_file_name_out]=stegano100_embed(im_file_name,key,psnr_min,m);

  % decode
  md=stegano100_decode(im_file_name_out,key,psnr_min);
  
  % verify message
  if length(m)<ml % take padding into acount if it happened
    m=[m(:)' zeros(1,ml-length(m))];
  end
  
  fprintf(1,'\nVerifying decoded message: ');  
  if sum(md~=m(1:ml))==0
    fprintf(1,'correct\n');
  else
    fprintf(1,'errors!!\n');
    mean(md~=m(1:ml))
  end

  % verify histograms
  im=imread(sprintf('images/%s',im_file_name));
  x=double(im(:)');
  vx=unique(x);
  hx=histc(x,vx);

  im=imread(im_file_name_out);
  y=double(im(:)');
  vy=unique(y);
  hy=histc(y,vy);
  
  fprintf(1,'Verifying histogram: ');
  if sum(hy~=hx)>0
    fprintf(1,'not preserved!!\n')
  else
    fprintf(1,'preserved\n')
  end
