function test_stegano100_lsb()
% TEST_STEGANO100_LSB - Test histogram-preserving LSB using permutation coding
%                       (static support partitioning used)

% $Id: test_stegano100_lsb.m,v 1.2 2014/10/13 17:44:52 felix Exp felix $
  
  % host file 
  im_file_name='lena512.png';
  % im_file_name='Goldhill.png';
  % im_file_name='boat.png';
  
  % create message 
  n=512^2; % embedding rate is close to 1 bpp in this case
  m=(rand(1,n)>.5);
  
  % choose some key
  key=floor(rand*2^32);
  
  % embed
  [ml,im_file_name_out]=stegano100_lsb_embed(im_file_name,key,m);

  % decode
  md=stegano100_lsb_decode(im_file_name_out,key);
  
  % verify message
  if length(m)<ml % if there was padding, take that into acount 
    m=[m(:)' zeros(1,ml-length(m))];
  end
  
  fprintf(1,'\nVerifying decoded message: ');
  if sum(md~=m(1:ml))==0
    fprintf(1,'correct\n');
  else
    fprintf(1,'errors!!\n');
    mean(md~=m(1:ml))
  end

  % verify histograms
  im=imread(sprintf('images/%s',im_file_name));
  x=double(im(:)');
  vx=unique(x);
  hx=histc(x,vx);

  im=imread(im_file_name_out);
  y=double(im(:)');
  vy=unique(y);
  hy=histc(y,vy);
  
  fprintf(1,'Verifying histogram: ');
  if sum(hy~=hx)>0
    fprintf(1,'not preserved!!\n')
  else
    fprintf(1,'preserved\n')
  end
