function [lr,dwr,dwrm,ef_lb,nu,sx,ub_lr]=theoreticals(x,u)
% THEORETICALS - Theoretical performance of partitioned permutation coding on x
%                using partitioning u
% 
%                       lr - log(r_j) (bits/partition, not rounded)
%                dwr, dwrm - average and maximum DWR
%                    ef_lb - approx. lower bound on average embedding efficiency
%                       nu - average degree of host change
%                       sx - sample variance per partition

% Copyright (C) 2014 Félix Balado and David Haughton
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
% $Id: theoreticals.m,v 1.6 2014/10/17 10:55:34 felix Exp $
    
    x=x(:)';
    
    % get unique partition indices within u
    uu=unique(u);
    
    % theoretical log(r)=sum(log(r_j))=sum(lr); exact if possible;
    % otherwise lr is a lower bound and ub_lr an upper bound
    lr=zeros(size(uu)); 
    ub_lr=zeros(size(uu)); 
    
    % theoretical DWR and DWRm
    wp=0; % initialize average watermark power
    mx=0; % initialize maximum watermark power
    sx=zeros(size(uu));
    
    % n \times \overline{\nu}
    nnu=0; 
    
    % compute theoreticals for each partition
    for j=1:length(uu) 
      xx=x(u==uu(j));
      nj=length(xx);
      if ~all(xx(1)==xx)
        % nonzero distortion, rate and degree of host change            
	incr=sort(xx);
	sx(j)=var(incr,1);
	wp=wp+2*nj*sx(j);
	mx=mx+2*(norm(xx)^2-incr(:)'*incr(end:-1:1)');
	
	vj=unique(incr);  
	hj=histc(incr,vj);
	
	[lr(j),ub_lr(j)]=log2_multinomial(hj); % bits/partition, no rounding
	
	nnu=nnu+nj*(1-norm(hj)^2/nj^2); 
      end
    end

    % DWR, DWRm
    dwr=10*log10(norm(x)^2/wp);
    dwrm=10*log10(norm(x)^2/mx); 

    % lower bound on average embedding efficiency
    % we use sum(floor(lr)) instead of sum(lr) to guarantee
    % a lower bound on the AVERAGE embedding efficiency for the empiricals
    % (the arithmetic coder can only handle an integer number of bits)
    k=(1-2^(-sum(floor(lr))))^2; % (r/(r-1))^2, note: 1/Inf=0 in Matlab
    ef_lb=k*sum(floor(lr))/nnu; 
    
    % degree of host change
    nu=nnu/length(x); 
    
