function filename=outputfile(outputdir,prefix,suffix)
% OUTPUTFILE - Generates univocal filenames for simulation files
%

% $Id: outputfile.m,v 1.1 2010/12/15 17:43:55 felix Exp felix $
  
    [dummy,host]=unix('hostname');
    host=strrep(host,' ','');
% remove pre and post "\n"
%    host=sprintf(host);

    host=strrep(host,sprintf('\n'),'');
    
    v=findstr(host,'.');
    if ~isempty(v)
        host=host(1:v(1)-1);  % remove everything after host name
    end
    
    filename=sprintf('%s_%s_%s_%s',prefix,host,datestr(now,'ddmmyy'),datestr(now,13));
    if nargin==3
        filename=sprintf('%s_%s',filename,suffix);
    end
    
    filename=strrep(filename,' ','');
    filename=strrep(filename,'.','');
    filename=strrep(filename,'/','');
    filename=strrep(filename,':','');
%    filename=sprintf('%s/%s.mat',outputdir,filename);
    filename=sprintf('%s/%s',outputdir,filename);    
  

 
