function [u,uh,new_p]=partitioning(x,p)
% PARTITIONING - obtain support partitioning uh with p partitions 
%                and roughly constant variance per partition 
%

% Copyright (C) 2014 Félix Balado and David Haughton
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
    
% $Id: partitioning.m,v 1.4 2014/10/17 09:46:09 felix Exp $

  x=x(:)';
  [v,i,j]=unique(x);
  q=length(v); % number of histogram bins

  if p<1 
    error('negative number of partitions');
  elseif p>q
    error('more partitions than unique values in host');
  end
    
  zeta=(v(end)-v(1))/p;  % size of partition interval
  
  c=v(1)+zeta/2+zeta*[0:p-1]; % p centroids
  
  %% assign label of closest mean
  vr=repmat(v,p,1);
  cr=repmat(c',1,q);
  d=(vr-cr).^2;
  [dummy,uh]=min(d,[],1);
  
  %% if v is not connected this uniform initialisation may end up with a 
  %% smaller p, so we just recompute it
  new_p=length(unique(uh));

  %% support-induced partitioning
  u=zeros(size(x));
  u=uh(j); % from unique(x)
  