#include <mex.h>
#include "math.h"
#include "inttypes.h"

/* Arithmetic encoder follows "Introduction to Data Compression"  */
/* by K. Sayood */

/* Note: C version of PERMUTATION_DECODING_M.M  */

/* Copyright (C) 2014 Félix Balado and David Haughton */

/* This program is free software: you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation, either version 3 of the License, or */
/* (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program.  If not, see <http://www.gnu.org/licenses/>.   */

/* $Id: permutation_decoding.c,v 1.6 2014/10/17 10:49:08 felix Exp $ */


void mexFunction(int nlhs, mxArray *plhs[],
		 int nrhs, const mxArray *prhs[])
{

  uint32_t q,q0,n,k,i,j,r;
  uint32_t sym_index,sub_index,b,bc;
  double *y,*v,*h,*out,*ml;
  uint32_t *m;
  uint32_t *c,*hs,*subs,*sub2sym;
  uint32_t underflow;

  mxArray *yy[1],*hh[1],*vv[1],*par[2];

  /* lower and higher ends of initial [0,1) interval, represented by 32 bits*/
  uint32_t low=0;
  uint32_t high=(uint32_t) -1; /* 2^{32}-1 */

  uint32_t bit32=(1<<31);
  uint32_t bit31=(1<<30);

  uint32_t new_low,new_high;
  double range;

  /* check arguments */
  if (nrhs != 2) 
    mexErrMsgTxt("Two inputs required");
  else if (nlhs > 1)
    mexErrMsgTxt("Too many output arguments");

  /* get pointers to arrays */
  y = mxGetPr(prhs[0]);
  n = mxGetM(prhs[0])*mxGetN(prhs[0]);
  ml =mxGetPr(prhs[1]); 

  yy[0]=prhs[0];
  mexCallMATLAB(1,vv,1,yy,"unique"); 
  q = mxGetM(vv[0])*mxGetN(vv[0]);
  q0 = q;
  v=mxGetPr(vv[0]);
  
  par[0]=prhs[0];
  par[1]=vv[0];
  mexCallMATLAB(1,hh,2,par,"histc"); 
  h=mxGetPr(hh[0]);

  sub2sym=mxCalloc(q,sizeof(uint32_t));
  hs=mxCalloc(q,sizeof(uint32_t));
  c=mxCalloc(q+1,sizeof(uint32_t));
  subs=mxCalloc(q+1,sizeof(uint32_t));

  /* big enough message vector m to be decoded */
  m=mxCalloc(ml[0],sizeof(uint32_t));

  underflow=0;
  i=0; /* decoded bit index */
  for(k=0;k<n;k++)
    {
      /* subinterval to symbol index mapping (for available symbols)*/
      r=0;
      for(j=0;j<q0;j++)
	if(h[j]>0)
	  {
	    sub2sym[r]=j;
	    hs[r]=h[j];
	    r++;
	  }
      q=r;

      /* cumulative sum of available symbol counts*/
      c[0]=0;
      for(j=0;j<q;j++)
	c[j+1]=c[j]+hs[j];
	    
      /* divide [low,high) interval into q subintervals proportional to h*/
      range=(double)high-(double)low+1;

      for(j=0;j<=q;j++)
	subs[j]=low+(uint32_t)floor(range*(double)c[j]/(double)c[q]);
      
      /* the k-th watermark symbol y(k) establishes the right subinterval*/
      for(sym_index=0;sym_index<q0;sym_index++)
	if(y[k]==v[sym_index])
	  break;
      h[sym_index]=h[sym_index]-1;

      /* find the subinterval index corresponding to that symbol*/
      for(sub_index=0;sub_index<q;sub_index++)
	if(sym_index==sub2sym[sub_index])
	  break;

      /* new interval before next step*/
      new_low=subs[sub_index];
      new_high=subs[sub_index+1]-1;
	
      while(((new_low&bit32)==(new_high&bit32))||
	    (((new_low&bit32)!=(new_high&bit32))&&((new_low&bit31)!=0)&&((new_high&bit31)==0)))
	{
	  if ((new_low&bit32)==(new_high&bit32))
            {
	      /* message bit decoded (compressed bit)*/
	      b=(uint32_t)((new_low&bit32)!=0);
	      if(i<ml[0])
		m[i]=b;
	      i++;
	      
	      /* shifts*/
	      new_low=(new_low<<1);
	      new_high=(new_high<<1);
	      new_high=(new_high|(uint32_t)1);
              
	      /* flush underflow bits if needed*/
	      if(underflow>0)
		{
		  bc=((b==0)?1:0);
		  for(j=0;j<underflow;j++)
		    {
		      if(i<ml[0])		      
			m[i]=bc;
		      i++;
		    }
		  underflow=0;
		}
            }
        
	  if ((new_low&bit32)!=(new_high&bit32)&&((new_low&bit31)!=0)&&((new_high&bit31)==0))
	    {      
	      underflow=underflow+1;
	      
	      /* shifts*/
	      new_low=(new_low<<1);
	      new_high=(new_high<<1);
	      new_high=(new_high|(uint32_t)1); /* lsb*/
                
	      /* complements*/
	      new_low=(new_low&(~bit32));
	      new_high=(new_high|bit32);
	    }
	}
 
        /* update interval*/
        low=new_low;
        high=new_high;
    }
 
  /* termination*/
  if(underflow==0)
    {
      for(j=0;j<32;j++)
	{
	  if(i<ml[0])
	    m[i]=(uint32_t)((new_high&bit32)!=0);
	  i++;
	  new_high=(new_high<<1);
	}
    }
  else
    {
      b=(uint32_t)((new_high&bit32)!=0);
      if(i<ml[0])
	m[i]=b;
      i++;
      bc=(uint32_t)(b?0:1);
      for(j=0;j<underflow;j++)
	{
	  if(i<ml[0])
	    m[i]=bc;
	  i++;
	}
      new_high=(new_high<<1);
      for(j=1;j<32;j++)
	{
	  if(i<ml[0])
	    m[i]=(uint32_t)((high&bit32)!=0);
	  i++;
	  new_high=(new_high<<1);
	}
    }
  
  /* only output ml bits */
  plhs[0] = mxCreateDoubleMatrix(1,ml[0],mxREAL);
  out = mxGetPr(plhs[0]);
  for (j=0;j<ml[0];j++) 
    out[j]=(double)m[j];

  mxFree(m);  
  mxFree(subs);
  mxFree(c);
  mxFree(hs);
  mxFree(sub2sym);

}
 
