function [ml,im_file_name_out]=stegano100_embed(im_file_name,key,psnr_min,m)
% STEGANO100_EMBED - 
%   
%         im_file_name - grayscale image, with extension
%                  key - symmetric key
%             psnr_min - minimum PSNR
%                    m - message to be embedded (binary vector)
%                   ml - length of message actually embedded
%     im_file_name_out - output file
  
% Copyright (C) 2014 Félix Balado and David Haughton
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.  
  
% $Id: stegano100_embed.m,v 1.3 2014/10/17 09:44:22 felix Exp $
    
    base_dir=[pwd '/output'];

    type=imfinfo(sprintf('images/%s',im_file_name));
    if ~strcmp(type.ColorType,'grayscale')
      error('Only grayscale images, please.');
    end
    
    im=imread(sprintf('images/%s',im_file_name));
    x=double(im(:)');
    n=length(x);
    
    %% find partitioning with minimum HWR
    vx=unique(x);
    found=0;
    fprintf('Finding best partitioning...\n');
    for p=length(vx):-1:1
      u=partitioning(x,p);    
      [lr,hwr,hwrm,lb_eff,nu,sx]=theoreticals(x,u); 
      psnr=hwr-10*log10(norm(x)^2)+10*log10(n*255^2);
      if psnr<psnr_min
	 found=1;
	 p=p+1;
	 break;
      else
	fprintf('\rPSNR=%.4f dB, rho=%.4f',psnr,sum(lr)/n);
      end
    end
    fprintf('\n');
    if ~found | p>length(vx)
      error(sprintf('No partitioning found for minimum PSNR=%.2f dB (lower your requirement)',psnr_min));
    end

    u=partitioning(x,p);    
    [lr,hwr,hwrm,lb_eff,nu,sx,ub_lr]=theoreticals(x,u);

    psnr=hwr-10*log10(norm(x)^2)+10*log10(n*255^2);
    rho=sum(ub_lr)/n;
    fprintf('\nTheoretical measures:\n\n');
    fprintf('Host to average watermark power ratio:\n\tHWR=%.4f dB (PSNR=%.4f dB), [minimum HWR=%.4f dB]\n',hwr,psnr,hwrm);
    fprintf('Average degree of host change:\n\tnu=%1.3f\n',nu);    
    fprintf('Upper bound on embedding rate:\n\trho=%.4f bits/host sample \n',rho);
    fprintf('Lower bound on average embedding efficiency:\n\tepsilon=%.4f bits/host sample change\n\n',lb_eff);
    
    prefix=sprintf('%s_pc_psnr_min_%.4f',im_file_name,psnr_min);
    out_file=outputfile(base_dir,prefix);
    fprintf('Output file: %s\n\n',out_file);
    
    % padding if needed
    ml=sum(floor(lr));
    if length(m)>ml
      fprintf(1,'Warning: only the first %i bits of the message are embeddable\n\n',ml);
    elseif length(m)<ml
      fprintf(1,'Warning: padding with zeros the last %i bits of the message\n\n',ml-length(m));
      m=[m(:)' zeros(1,ml-length(m))];
    end
    
    fprintf('Embedding...\n');
    y=zeros(size(x));
    uu=unique(u);
    i=1;
    rand('twister',key); % initialise pseudorandom generator
    for j=1:length(uu)
      fprintf('\rPartition: %i/%i',j,length(uu));
      mjl=floor(lr(j));
      x_j=x(u==uu(j));
      if mjl>0
	ind_key=randperm(length(x_j));
	m_j=m(i:i+mjl-1); 
	% y_j=permutation_encoding_m(x_j,m_j); % matlab
	y_j=permutation_encoding(x_j,double(m_j));   % mex
	y_j=y_j(ind_key);
	y(u==uu(j))=y_j;
      else
	y(u==uu(j))=x_j;
      end
      i=i+mjl;
    end   
    fprintf('\n\n');
    
    emp_hwr=10*log10(norm(x)^2/norm(y-x)^2);
    emp_psnr=10*log10(n*255^2/norm(y-x)^2);
    emp_rho=ml/n;
    dyx=sum(y~=x);
    emp_nu=dyx/n;
    if dyx>0
      emp_eff=ml/dyx;
    else
      emp_eff=0;
    end
    fprintf('Empirical measures:\n\n');
    fprintf('Host to watermark power ratio:\n\tHWR=%.4f dB (PSNR=%.4f dB)\n',emp_hwr,emp_psnr);
    fprintf('Degree of host change:\n\tnu=%1.3f\n',emp_nu);    
    fprintf('Embedding rate:\n\trho=%.4f bits/host sample\n',emp_rho);
    fprintf('Embedding efficiency:\n\tepsilon=%.4f bits/host sample change\n\n',emp_eff);
    
% save watermarked image
    im_w=reshape(y(:),size(im,1),size(im,2));
    im_file_name_out=sprintf('%s.png',out_file);
    fprintf('Saving: %s\n',im_file_name_out);
    imwrite(uint8(im_w),im_file_name_out,'png'); 
      
